function [En,sysfin,Efin,TESfin]=affinage(sys,m,En,varargin)
%   AFFINAGE permet d'affiner la dtermination de l'nergie d'un tat confin
%   [En,sysfin,Efin,TESfin]=AFFINAGE(sys,m,En,varargin)
%       >> sys          = Systme {Objet physique - nergie potentielle}
%       >> m            = Masse de l'objet physique
%       >> En           = Energie de l'tat confin ( affiner)
%       >> varargin     = Arguments d'entre optionnels
%                           > alpha     = Facteur (<< 1) tel que 2*alpha*En est le nouvel intervalle nergtique centr sur En
%                           > nE        = Nombre de valeurs de l'nergie
%                           > Emin      = Energie la plus basse du nouvel intervalle nergtique
%                           > Emax      = Energie la plus haute du nouvel intervalle nergtique
%       << En           = Valeur affine de l'nergie de l'tat confin
%       << sysfin       = Nouveau systme sur l'intervalle nergtique 
%       << Efin         = Nouvelles valeurs affines de l'nergie
%       << TESfin       = Matrice de transfert de sysfin
%
%   Olivier Pujol : septembre 2013
%
%% Rcupration des caractristiques du systme

xt=nan(1,length(sys{1})-1);
Ep=nan(1,length(sys{1}));
M=cell(1,length(sys{1}));

Ep(1)=sys{1}{1}(1);
for ic=2:length(sys{1})
    xt(ic-1)=get(sys{1}{ic},'Position');
    Ep(ic)=get(sys{1}{ic},'EnergiePotentielleSortie');
    M{ic-1}=char(get(sys{1}{ic},'Nom'));
end

clear sys

%% Arguments d'entre optionnels

switch length(varargin)
    case 0
        alpha=0.01;                 % Valeur par dfaut du pourcentage
        nE=400;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 1
        alpha=varargin{1};          % Valeur par dfaut du nombre de points selon Ox
        nE=400;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 2
        alpha=varargin{1};          % Valeur par dfaut du nombre de points selon Ox
        nE=varargin{2};             % Valeur par dfaut du nombre de valeurs de l'nergie
    case 3
        Efin=linspace(varargin{1},varargin{2},varargin{3});     % Ensemble des valeurs de l'nergie (origine au fond du puits)
    otherwise
        ('Mauvais nombre d''arguments d''entre optionnels');
end

%% Calcul de la valeur affine de En. 

%   Autour de la valeur approche En fournie au dpart, on dfinit un
%   intervalle  +/- alpha*En, (alpha < 1 ; dfaut : 0,01).

if (length(varargin)~=3)
    Emin=(1-alpha)*En;
    Emax=(1+alpha)*En;
    Efin=linspace(Emin,Emax,nE);
end

%   On recalcule le systme total sur cet intervalle

[sysfin,Efin]=Epot(M,xt,Ep,m,Efin);
TESfin=matrix(sysfin);
clear M xt En

dfin=nan(1,length(TESfin));         % Initialisation
for iT=1:size(TESfin,2)
    dfin(iT)=TESfin{iT}(2,2);       % Elment d
end

En=minimum(Efin,dfin);

%% Affichage graphique de l'affinage

figure
plot(log(abs(dfin)),Efin,'b');
axis([min(log(abs(dfin))) max(log(abs(dfin))) min(Efin) max(Efin)]); 
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
title('Zoom sur l''nergie d''un tat confin');
xlabel('ln(|d|)');
ylabel('Energie (eV)','Color','k');

return;

function Econf=minimum(Efin,dfin)

derivee=diff(log(abs(dfin)));
Ind=derivee(1:end-1).*derivee(2:end) <=0;
Econf=Efin(Ind==1);

return;
